    
<?php $__env->startSection('main-content'); ?>
  
  <section class="section">
        <div class="section-header">
            <h1><?php echo e(__('role.roles')); ?></h1>
            <?php echo e(Breadcrumbs::render('roles')); ?>

        </div>

        <div class="section-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role_create')): ?>
                            <div class="card-header">
                                <a href="<?php echo e(route('admin.role.create')); ?>" class="btn btn-icon icon-left btn-primary"><i class="fas fa-plus"></i> <?php echo e(__('Add Role')); ?></a>
                            </div>
                        <?php endif; ?>

                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th><?php echo e(__('levels.id')); ?></th>
                                            <th><?php echo e(__('levels.name')); ?></th>
                                            <?php if(auth()->user()->can('role_show') || auth()->user()->can('role_edit') || auth()->user()->can('role_delete')): ?>
                                                <th><?php echo e(__('levels.actions')); ?></th>
                                            <?php endif; ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if(!blank($roles)): ?>
                                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($loop->index+1); ?></td>
                                                    <td><?php echo e($role->name); ?></td>
                                                    
                                                    <?php if(auth()->user()->can('role_show') || auth()->user()->can('role_edit') || auth()->user()->can('role_delete')): ?>
                                                        <td>
                                                            <?php if(auth()->user()->can('role_show')): ?>
                                                                <a href="<?php echo e(route('admin.role.show', $role)); ?>" class="btn btn-sm btn-icon float-left btn-success" data-toggle="tooltip" data-placement="top" title="Permission"><i class="fas fa-plus"></i></a>
                                                            <?php endif; ?>

                                                            <?php if(auth()->user()->can('role_edit')): ?>
                                                                <a href="<?php echo e(route('admin.role.edit', $role)); ?>" class="btn btn-sm btn-icon float-left btn-primary ml-2" data-toggle="tooltip" data-placement="top" title="Edit"><i class="far fa-edit"></i></a>
                                                            <?php endif; ?>

                                                            <?php if(!in_array($role->id, $notDeleteArray) && auth()->user()->can('role_delete')): ?>
                                                                <form class="float-left pl-2" action="<?php echo e(route('admin.role.destroy', $role)); ?>" method="POST">
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php echo method_field('DELETE'); ?>
                                                                    <button class="btn btn-sm btn-icon btn-danger" data-toggle="tooltip" data-placement="top" title="Delete"><i class="fa fa-trash"></i></button>
                                                                </form>
                                                            <?php endif; ?>
                                                        </td>
                                                    <?php endif; ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mmatwoco/public_html/vms/resources/views/admin/role/index.blade.php ENDPATH**/ ?>