<?php $__env->startSection('content'); ?>
<section class="h-screen">
    <div class="container pb-8">
        <?php if(isset($visitingDetails)): ?>
        <div class="mt-8 max-w-[571px] w-full mx-auto p-6 sm:px-16 sm:pb-16 pt-6 sm:pt-11 rounded-2xl backdrop-blur-lg bg-cardBg shadow-card flex flex-col items-center">
            <h1 class="text-2xl sm:text-[32px] font-extrabold text-primary leading-snug"><?php echo e(__('frontend.visitor_id_card')); ?></h1>
            <div class="bg-white rounded-lg mt-6 sm:mt-11 w-full shadow-idcard" id="printidcard">
                <div class="idcard">
                    <div class="bg-gradient-to-r from-[#496FD7] to-[#46A5ED] rounded-t-lg lg p-4">
                        <div class="flex justify-between items-center card-header">
                            <div class="flex items-center justify-center gap-[6px] company-details">
                                <div class="w-8 h-8 bg-white flex items-center logo-img rounded-lg">
                                    <img class="w-full logo" src="<?php echo e(asset('images/'.setting('site_logo'))); ?>" alt="logo">
                                </div>
                                <div class="text-[10px] font-bold text-white company-name">
                                    <p><?php echo e(setting('site_name')); ?> </p>
                                </div>
                            </div>

                            <div class="flex flex-col text-[10px] font-base text-white leading-none company-address">
                                <p><?php echo e(setting('site_address')); ?></p>
                                <p class="my-2"><?php echo e(__('E-mail:')); ?> <?php echo e(setting('site_email')); ?></p>
                                <?php if(setting('site_phone')): ?>
                                <p><?php echo e(__('Phone:')); ?> <?php echo e(setting('site_phone')); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="p-6 flex justify-start gap-x-[18px] card-body">
                        <div class="w-36 h-36 user-image">
                            <?php if($visitingDetails->getFirstMediaUrl('visitor')): ?>
                            <img src="<?php echo e(asset($visitingDetails->getFirstMediaUrl('visitor'))); ?>" alt="user" class="w-full h-full rounded-xl">
                            <?php elseif($visitingDetails['photo']): ?>
                            <img src="<?php echo e($visitingDetails['photo']); ?>" alt="user" class="w-full h-full rounded-xl">
                            <?php elseif(\App\Enums\Status::MALE== $visitingDetails->visitor->gender): ?>
                            <img src="<?php echo e(asset('/frontend/images/avatars/avatar5.png)); ?>" alt="user" class="w-full rounded-xl">
                            <?php else: ?>
                            <img src="<?php echo e(asset('/frontend/images/avatars/avatar4.png)); ?>" alt="user" class="w-full rounded-xl">
                            <?php endif; ?>
                        </div>
                        <div class="user-details">
                            <div>
                                <p class="text-base md:text-[20px] font-semibold text-primary leading-none user-name"><?php echo e($visitingDetails->visitor->name); ?></p>
                                <p class="text-[14px] font-normal mt-1">ID#<?php echo e($visitingDetails->reg_no); ?></p>
                            </div>
                            <div class="mt-3 mb-3 phone">
                                <h2 class="text-[14px] font-semibold text-primary"><?php echo e(__('frontend.phone')); ?></h2>
                                <p class="text-[14px] font-normal">+<?php echo e($visitingDetails->visitor->country_code); ?><?php echo e($visitingDetails->visitor->phone); ?></p>
                            </div>
                            <div>
                                <h2 class="text-[14px] font-semibold text-primary"><?php echo e(__('frontend.host')); ?></h2>
                                <p class="text-[14px] font-normal"><?php echo e($visitingDetails->employee->name); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <div class="flex flex-wrap gap-y-2 sm:gap-y-0 justify-between items-center max-w-[571px] w-full mx-auto mt-7">
            <a href="<?php echo e(route('check-in')); ?>"><button type="reset" class="flex justify-start  bg-danger text-white px-6 py-3 rounded-3xl shadow-btnDanger text-lg font-bold leading-none"><?php echo e(__('frontend.back')); ?></button></a>
            <div class="flex flex-wrap justify-end gap-4">
                <?php if($visitingDetails->visitor): ?>
                <a href="#" id="print"><button class="bg-success text-white px-6 py-3 rounded-3xl shadow-btnSuccess text-lg font-bold leading-none"><?php echo e(__('frontend.print_id')); ?></button></a>
                <?php endif; ?>
                <a href="<?php echo e(route('check-in')); ?>"><button type="submit" class="bg-primary text-lg font-bold text-white px-6 py-3 rounded-3xl shadow-btnNext leading-none"><?php echo e(__('frontend.home')); ?></button></a>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
    function printData(data) {
        var frame1 = $('<iframe />');
        var css = "<?php echo e(asset('css/id-card-print-frontend.css')); ?>";
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html><head><title>visitor ID Card</title>');
        frameDoc.document.write('<link href="' + css + '" rel="stylesheet" type="text/css" />');
        frameDoc.document.write('</head><body>');
        //Append the external CSS file.
        //Append the DIV contents.
        frameDoc.document.write(data);
        frameDoc.document.write('</body></html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
        }, 500);
    }

    $('#print').on('click', function() {
        var data = $("#printidcard").html();
        printData(data);
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mmatwoco/public_html/vms/resources/views/frontend/check-in/show.blade.php ENDPATH**/ ?>